 ; Ŀ
 ;   Raji - suck text into underlying attributes.                          
 ;   Multiple block version for batch use.                                 
 ;   Copyright 1994, 1995, 2005, 2007, 2008 by Rocket Software Ltd.        
 ;   Debugging is hardest when the program is doing exactly what you       
 ;   wanted and not what you think it is.                                  
 ; 

 ; Ŀ
 ;   Clenuf - find the attribute in a list whose insertion point is        
 ;   closest to that of a text entity.                                     
 ;   Arguments: Pa, the entity midpoint.                                   
 ;              Plist, the list of attribute midpoints and enames.         
 ;   Returns an attribute ename and the list minus that sublist.           
 ; 
 (DEFUN CLENUF (pa plist / num sub distc mindis minlis gnulis)
  (setq num 0)
  (while (setq sub (nth num plist))
         (setq num (1+ num))
         (setq distc (distance pa (car sub)))
 ; Ŀ
 ;   If this is the first cycle, save the sublist and the distance.        
 ; 
         (cond ((null mindis)
                (setq mindis distc)
                (setq minlis sub))
 ; Ŀ
 ;   An amusing section: If the current distance is less than the saved    
 ;   least distance then add the saved data list to gnulis and save the    
 ;   current data list instead.                                            
 ; 
               ((< distc mindis)
                (setq mindis distc)
                (setq gnulis (append gnulis (list minlis)))
                (setq minlis sub))
 ; Ŀ
 ;   Otherwise just move the sublist to the new list.                      
 ; 
               (t
                (setq gnulis (append gnulis (list sub))))))
 (list (cadr minlis) gnulis))
 ; Ŀ
 ;   Clenuf end.                                                           
 ; 

 ; Ŀ
 ;   Ftxy - find all text and blocks crossing an area.                     
 ;   Takes no arguments, calls Poxy.                                       
 ;   Returns an ss.                                                        
 ; 
 (DEFUN FTXY (llpt urpt / osna enam entt pa ds llxp llyp urxp uryp ll ur ss)
  (setq osna (getvar "osmode"))
  (setvar "osmode" 0) 
 ; Ŀ
 ;   Find the corners of the selection area.                               
 ; 
  (if (setq enam (ssname (ssget "x" (list (cons 2 "x-logo"))) 0))
      (progn
           (setq entt (entget enam))
           (setq pa (cdr (assoc 10 entt)))
           (setq ds (cdr (assoc 41 entt)))
           (setq llxp (+ (car pa) (* (car llpt) ds)))
           (setq llyp (+ (cadr pa) (* (cadr llpt) ds)))
           (setq urxp (+ (car pa) (* (car urpt) ds)))
           (setq uryp (+ (cadr pa) (* (cadr urpt) ds)))
           (setq ll (list llxp llyp))
           (setq ur (list urxp uryp))
           (poxy ll ur)
 ; Ŀ
 ;   Find all text and block insertions in the selected area.              
 ; 
           (setq ss (ssget "c" ll ur '((-4 . "<or") (0 . "text")
                                                    (0 . "insert")
                                       (-4 . "or>"))))))
  (setvar "osmode" osna)
 ; Ŀ
 ;   Return the ss.                                                        
 ; 
 ss)
 ; Ŀ
 ;   Subroutine Ftxy end.                                                  
 ; 

 ; Ŀ
 ;   Poxy: draw a temporary marker box.                                    
 ;   Arguments: Aa, a corner point.                                        
 ;              Cc, another corner point.                                  
 ; 
 (defun poxy (aa cc / bb dd)
  (setq bb (cons (car cc) (cdr aa)))
  (setq dd (cons (car aa) (cdr cc)))
  (grdraw aa bb 130)
  (grdraw bb cc 130)
  (grdraw cc dd 130)
  (grdraw dd aa 130)
 (princ))
 ; Ŀ
 ;   Poxy end.                                                             
 ; 

 ; Ŀ
 ;   Reba - make a block into a list: ((inspoint attribute_ename) ...).    
 ;   Arguments: Enam, a block insertion ename.                             
 ;   Returns a list.                                                       
 ; 
 (DEFUN REBA (enam / entt pa malist)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq pa (spit (entget enam)))
         (setq malist (cons (list pa enam) malist)))
 malist)
 ; Ŀ
 ;   Reba end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Raji.                                                                 
 ; 
 (DEFUN C:RAJI (/ ss ss1 num ssins enam sub malist entt str pa atnam insnam
                                                                        blist)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get a selection set of text and blocks.                               
 ; 
  (setq llofs (list 247.00 7.00))
  (setq urofs (list 397.00 64.00))
  (setq ss (ftxy llofs urofs))
 ; Ŀ
 ;   And another.                                                          
 ; 
  (setq llofs (list 695.00 4.00))
  (setq urofs (list 860.00 60.00))
  (setq ss1 (ftxy llofs urofs))
 ; Ŀ
 ;   Combine them.                                                         
 ; 
  (setq num 0)
  (while (setq enam (ssname ss1 num))
         (ssadd enam ss)
         (setq num (1+ num)))
 ; Ŀ
 ;   Split it into two lists, one for each entity type.                    
 ; 
  (setq num 0)
  (setq ssins (ssadd))
  (while (setq enam (ssname ss num))
         (if (= (cdr (assoc 0 (entget enam))) "INSERT")
             (progn
                  (ssadd enam ssins)
                  (ssdel enam ss))
             (setq num (1+ num))))
 ; Ŀ
 ;   Reduce the block ss to a list: ((insertion attribute_ename) ...).     
 ; 
  (setq num 0)
  (while (setq enam (ssname ssins num))
         (setq num (1+ num))
         (setq sub (reba enam))
         (setq malist (append malist sub)))
 ; Ŀ
 ;   Step through the text selection set.                                  
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
 ; Ŀ
 ;   Get the string, find the insertion point, erase the text entity.      
 ; 
         (setq str (cdr (assoc 1 entt)))
         (setq pa (spit entt))
         (entdel enam)
 ; Ŀ
 ;   Find the attribute whose insertion point is closest to the insertion  
 ;   point of the text.                                                    
 ; 
         (setq atnam (clenuf pa malist))         
         (setq malist (cadr atnam))
         (setq atnam (car atnam))
         (setq entt (entget atnam))
         (entmod (subst (cons 1 str) (assoc 1 entt) entt))
 ; Ŀ
 ;   Save the name of the insert to a list if it isn't already a member.   
 ; 
         (setq insnam (cdr (assoc 330 entt)))
         (if (not (member insnam blist))
             (setq blist (cons insnam blist))))
 ; Ŀ
 ;   Update the blocks which were changed.                                 
 ; 
  (setq num 0)
  (while (setq enam (nth num blist))
         (setq num (1+ num))
         (entupd enam))
 (princ))